@echo off
rem author: Rony G. Flatscher, 2026-01-22
rem purpose: set environment in a termianl to allow Weka to be used

rem define WEKA_HOME
set  WEKA_HOME=%~dp0
rem remove trailing backslash
set "WEKA_HOME=%WEKA_HOME:~0,-1%"

rem add necessary Weka directories to CLASSPATH
rem set CLASSPATH=%CLASSPATH%;%WEKA_HOME%\*;%WEKA_HOME%\rgf\*;%WEKA_HOME%\rgf\lib\*
set CLASSPATH=%CLASSPATH%;%WEKA_HOME%\*

rem add Weka related --add-opens (module related) for the JVM
set JDK_JAVA_OPTIONS=--add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED %JDK_JAVA_OPTIONS%
echo JDK_JAVA_OPTIONS=%JDK_JAVA_OPTIONS%
echo.

echo Weka related environment variable set
echo WEKA_HOME=%WEKA_HOME%
echo CLASSPATH=%CLASSPATH%
echo.

echo to run the gui enter either
echo.
echo    java -jar weka.jar
echo or
echo    java -jar %%WEKA_HOME%%\weka.jar
echo or
echo    java -jar "%WEKA_HOME%\weka.jar"
echo.
echo to run ooRexx programs use rexxjh.sh, e.g.,
echo.
echo    rexxjh WU\01_TestWeka\rxTestWeka.rxj
echo.

