#!/bin/sh
# author: Rony G. Flatscher, 2026-01-22, 2026-01-26
# purpose: set environment in a terminal to allow Weka to be used

# define WEKA_HOME
export WEKA_HOME="$(cd "$(dirname "$0")" && pwd)"

# add necessary Weka directories to CLASSPATH
# export CLASSPATH=$CLASSPATH:$WEKA_HOME/'*':$WEKA_HOME/rgf/'*':$WEKA_HOME/rgf/lib/'*'
export CLASSPATH=$CLASSPATH:$WEKA_HOME/'*'

# add Weka related --add-opens (module related) for the JVM
export JDK_JAVA_OPTIONS="--add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED $JDK_JAVA_OPTIONS"
echo JDK_JAVA_OPTIONS=$JDK_JAVA_OPTIONS
echo

echo Weka related environment variable set
echo WEKA_HOME=$WEKA_HOME
echo CLASSPATH=$CLASSPATH
echo

echo to run the gui enter either
echo
echo    java -jar weka.jar
echo or
echo    java -jar \$WEKA_HOME/weka.jar
echo
echo    java -jar "\$WEKA_HOME/weka.jar"
echo
echo
echo to run ooRexx programs use rexxjh.sh, e.g.,
echo
echo    rexxjh.sh WU/01_TestWeka/rxTestWeka.rxj
